/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SubjectAltNames
implements Serializable,
CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTSAND";
    private static final String TRACE_MASKF = "XCRTSANF";
    private static final String TRACE_MASKT = "XCRTSANT";
    HashSet dnsTypeNames = new HashSet();
    HashSet iPAddrTypeNames = new HashSet();

    SubjectAltNames() {
        Trace.trace(TRACE_MASKT, "<->SubjectAltNames()");
    }

    SubjectAltNames(HashSet alternateDNSNames, HashSet ipAddresses) {
        if (alternateDNSNames == null || ipAddresses == null) {
            throw new IllegalArgumentException("The SubjectAltNames class is being instantiated with a null parameter.");
        }
        this.dnsTypeNames = alternateDNSNames;
        this.iPAddrTypeNames = ipAddresses;
        Trace.trace(TRACE_MASKT, "<->SubjectAltNames(" + alternateDNSNames + ", " + ipAddresses + ")");
    }

    SubjectAltNames(X509Certificate certificate) throws HException {
        Collection<List<?>> subjectAltNames = null;
        List<?> subjectAltNameEntry = null;
        Integer subjectAltNameEntryType = null;
        Object subjectAltNameEntryValue = null;
        Trace.trace(TRACE_MASKT, "->SubjectAltNames(" + certificate + ")");
        try {
            subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                Iterator<List<?>> i = subjectAltNames.iterator();
                block13: while (i.hasNext()) {
                    subjectAltNameEntry = i.next();
                    subjectAltNameEntryType = (Integer)subjectAltNameEntry.get(0);
                    subjectAltNameEntryValue = subjectAltNameEntry.get(1);
                    switch (subjectAltNameEntryType) {
                        case 0: {
                            continue block13;
                        }
                        case 1: {
                            continue block13;
                        }
                        case 2: {
                            this.dnsTypeNames.add(subjectAltNameEntryValue);
                            continue block13;
                        }
                        case 3: {
                            continue block13;
                        }
                        case 4: {
                            continue block13;
                        }
                        case 5: {
                            continue block13;
                        }
                        case 6: {
                            continue block13;
                        }
                        case 7: {
                            this.iPAddrTypeNames.add(subjectAltNameEntryValue);
                            continue block13;
                        }
                        case 8: {
                            continue block13;
                        }
                    }
                }
            }
        }
        catch (CertificateParsingException e) {
            Trace.trace(TRACE_MASKF, "CertificateParsingException thrown getting subject alternative names: " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 9, e).log();
            throw new HException(e);
        }
    }

    SubjectAltNames(SubjectAltNames namesToClone) {
        if (namesToClone != null) {
            this.dnsTypeNames = namesToClone.dnsTypeNames != null ? (HashSet)namesToClone.dnsTypeNames.clone() : null;
            this.iPAddrTypeNames = namesToClone.iPAddrTypeNames != null ? (HashSet)namesToClone.iPAddrTypeNames.clone() : null;
        }
    }

    public static void main(String[] args) {
    }

    public String toString() {
        StringBuffer subjectAltNamesSB = null;
        subjectAltNamesSB = new StringBuffer();
        Iterator i = this.dnsTypeNames.iterator();
        while (i.hasNext()) {
            SubjectAltNames.appendTypeValue(subjectAltNamesSB, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "dNSName").toString(), (String)i.next());
        }
        i = this.iPAddrTypeNames.iterator();
        while (i.hasNext()) {
            SubjectAltNames.appendTypeValue(subjectAltNamesSB, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "iPAddress").toString(), (String)i.next());
        }
        return subjectAltNamesSB.toString();
    }

    HashSet getDNSNames() {
        return this.dnsTypeNames;
    }

    HashSet getIPAddrNames() {
        return this.iPAddrTypeNames;
    }

    void addDNSName(String s) {
        this.dnsTypeNames.add(s);
    }

    void addIPAddrName(String s) {
        this.iPAddrTypeNames.add(s);
    }

    private static void appendTypeValue(StringBuffer sb, String entryType, String value) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(entryType);
        sb.append(": ");
        sb.append(value);
    }

    public boolean equals(Object otherObject) {
        boolean result = false;
        SubjectAltNames other = null;
        if (otherObject != null && otherObject instanceof SubjectAltNames) {
            other = (SubjectAltNames)otherObject;
            if ((this.dnsTypeNames == null ? other.dnsTypeNames == null : this.dnsTypeNames.equals(other.dnsTypeNames)) && (this.iPAddrTypeNames == null ? other.iPAddrTypeNames == null : this.iPAddrTypeNames.equals(other.iPAddrTypeNames))) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

